/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWActionType;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWEventDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWJoinType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWMergeType;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWSimpleInstruction;
import filenet.vw.api.VWSplitType;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepPaletteDefinition;
import filenet.vw.api.VWWFEInstruction;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowRuntimeId;
import filenet.vw.api.VWXMLHandler;
import java.awt.Point;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class VWXML_30_parser {
    VWXML_30_parser() {
    }

    protected static VWWorkflowDefinition parseXMLWorkflow(Element wfele) throws VWException, SAXException {
        if (!wfele.getTagName().equals("WorkFlowDefinition")) {
            return null;
        }
        VWWorkflowDefinition wfdef = new VWWorkflowDefinition(true);
        wfdef.setVersionAgnostic(false);
        wfdef.setValidateUsingSchema(false);
        if (wfele.getAttributeNode("Name") != null) {
            wfdef.setName(wfele.getAttribute("Name"));
        }
        if (wfele.getAttributeNode("Subject") != null) {
            wfdef.setSubject(wfele.getAttribute("Subject"));
        }
        if (wfele.getAttributeNode("Description") != null) {
            wfdef.setDescription(wfele.getAttribute("Description"));
        }
        if (wfele.getAttributeNode("MainAttachment") != null) {
            wfdef.setMainAttachmentNameNoValidate(wfele.getAttribute("MainAttachment"));
        }
        if (wfele.getAttributeNode("Deadline") != null) {
            wfdef.setDeadline(Long.parseLong(wfele.getAttribute("Deadline")));
        }
        if (wfele.getAttributeNode("Reminder") != null) {
            wfdef.setReminder(Long.parseLong(wfele.getAttribute("Reminder")));
        }
        if (wfele.getAttributeNode("DisableEmailNotification") != null) {
            wfdef.setDisableEmailNotification(VWXMLHandler.stringToBoolean(wfele.getAttribute("DisableEmailNotification")));
        }
        if (wfele.getAttributeNode("BaseWorkClass") != null) {
            wfdef.setBaseWorkClassName(wfele.getAttribute("BaseWorkClass"));
        }
        if (wfele.getAttributeNode("Roster") != null) {
            wfdef.setRosterName(wfele.getAttribute("Roster"));
        }
        if (wfele.getAttributeNode("EventLog") != null) {
            wfdef.setEventLogName(wfele.getAttribute("EventLog"));
        }
        if (wfele.getAttributeNode("Tag") != null) {
            wfdef.setTag(wfele.getAttribute("Tag"));
        }
        if (wfele.getAttributeNode("AuthorTool") != null) {
            wfdef.setAuthorTool(wfele.getAttribute("AuthorTool"));
        }
        if (wfele.getAttributeNode("OtherAuthorTools") != null) {
            wfdef.setOtherAuthorTools(wfele.getAttribute("OtherAuthorTools"));
        }
        NodeList childNodes = wfele.getChildNodes();
        int numChilds = 0;
        if (childNodes != null) {
            numChilds = childNodes.getLength();
        }
        if (numChilds != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node aNode = childNodes.item(i);
                if (aNode.getNodeName().equals("Field")) {
                    VWXML_30_parser.parseXMLFieldDefinition(aNode, wfdef);
                    continue;
                }
                if (aNode.getNodeName().equals("Map")) {
                    VWXML_30_parser.parseXMLMapDefinition(aNode, wfdef);
                    continue;
                }
                if (aNode.getNodeName().equals("Milestone")) {
                    VWXML_30_parser.parseXMLMilestoneDefinition(aNode, wfdef);
                    continue;
                }
                if (aNode.getNodeName().equals("RuleSet")) {
                    VWXML_30_parser.parseXMLRuleSetDefinition(aNode, wfdef);
                    continue;
                }
                if (aNode.getNodeName().equals("ModelAttributes")) {
                    Hashtable attributes = VWXML_30_parser.parseXMLModelAttributes(aNode);
                    wfdef.setAttributes(attributes);
                    continue;
                }
                if (!aNode.getNodeName().equals("WFRuntimeId")) continue;
                VWXML_30_parser.parseXMLRuntimeId(aNode, wfdef);
            }
        }
        return wfdef;
    }

    protected static void parseXMLFieldDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode == null) {
            return;
        }
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String nameStr = null;
        String valueStr = null;
        if (ele.getAttributeNode("Name") != null) {
            nameStr = ele.getAttribute("Name");
        }
        if (ele.getAttributeNode("ValueExpr") != null) {
            valueStr = ele.getAttribute("ValueExpr");
        }
        int typeInt = VWFieldType.stringToType(ele.getAttribute("Type"));
        boolean isArrayBool = VWXMLHandler.stringToBoolean(ele.getAttribute("IsArray"));
        int mergeInt = VWMergeType.stringToType(ele.getAttribute("MergeType"));
        VWFieldDefinition fldDef = nameStr != null && nameStr.equals("F_Trackers") ? wfdef.createFieldNoValidateName(nameStr, valueStr, typeInt, isArrayBool) : wfdef.createFieldUsingString(nameStr, valueStr, typeInt, isArrayBool);
        fldDef.setMergeType(mergeInt);
        if (ele.getAttributeNode("Description") != null) {
            fldDef.setDescription(ele.getAttribute("Description"));
        }
    }

    protected static void parseXMLMilestoneDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String nameStr = null;
        if (ele.getAttributeNode("Name") != null) {
            nameStr = ele.getAttribute("Name");
        }
        VWMilestoneDefinition mileStone = wfdef.createMilestone(nameStr);
        if (ele.getAttributeNode("Message") != null) {
            mileStone.setMessage(ele.getAttribute("Message"));
        }
        if (ele.getAttributeNode("Level") != null) {
            mileStone.setLevel(Integer.parseInt(ele.getAttribute("Level")));
        }
    }

    protected static void parseXMLRuleSetDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String valueStr = null;
        if (ele.getAttributeNode("Val") != null) {
            valueStr = ele.getAttribute("Val");
        }
        wfdef.createRuleSet(valueStr);
    }

    protected static void parseXMLMapDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException, SAXException, NumberFormatException {
        Element ele = (Element)aNode;
        NodeList childNodes = aNode.getChildNodes();
        String nameStr = ele.getAttribute("Name");
        VWMapDefinition map = wfdef.createEmptyMap(nameStr);
        if (ele.getAttributeNode("Description") != null) {
            map.setDescription(ele.getAttribute("Description"));
        }
        if (ele.getAttributeNode("MapId") != null) {
            map.setMapId(Integer.parseInt(ele.getAttribute("MapId")));
        }
        int numChilds = 0;
        if (childNodes != null) {
            numChilds = childNodes.getLength();
        }
        for (int i = 0; i < numChilds; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Step")) {
                VWXML_30_parser.parseXMLStepDefinition(childNode, map, null);
            }
            if (!childNode.getNodeName().equals("CompoundStep")) continue;
            VWXML_30_parser.parseXMLCompoundStepDefinition(childNode, map, null);
        }
        if (ele.getAttributeNode("MaxStepId") != null) {
            int maxStepId = Integer.parseInt(ele.getAttribute("MaxStepId"));
            if (maxStepId >= map.findHighestStepId()) {
                map.getStepIdGenerator().setNextId(maxStepId + 1);
            } else {
                map.updateNextStepId();
            }
        } else {
            map.updateNextStepId();
        }
    }

    protected static void parseXMLStepDefinition(Node aNode, VWMapDefinition map, VWStepPaletteDefinition spDef) throws VWException, SAXException {
        VWStepDefinition step = null;
        VWArrayHandler partHandler = new VWArrayHandler(1, 1);
        VWArrayHandler responseHandler = new VWArrayHandler(1, 1);
        Element ele = (Element)aNode;
        if (map != null) {
            step = map.createEmptyStep();
        } else if (spDef != null) {
            step = spDef.createEmptyStep();
        }
        if (ele.getAttributeNode("Name") != null) {
            step.setName(ele.getAttribute("Name"));
        }
        if (ele.getAttributeNode("StepId") != null) {
            step.setStepId(Integer.parseInt(ele.getAttribute("StepId")));
        }
        if (ele.getAttributeNode("Description") != null) {
            step.setDescription(ele.getAttribute("Description"));
        }
        if (ele.getAttributeNode("QueueName") != null) {
            step.setQueueName(ele.getAttribute("QueueName"));
        }
        if (ele.getAttributeNode("OperationName") != null) {
            step.setOperationName(ele.getAttribute("OperationName"));
        }
        if (ele.getAttributeNode("PreMilestone") != null && map != null) {
            step.setPreMilestone(ele.getAttribute("PreMilestone"));
        }
        if (ele.getAttributeNode("PostMilestone") != null && map != null) {
            step.setPostMilestone(ele.getAttribute("PostMilestone"));
        }
        if (ele.getAttributeNode("RequestedInterface") != null) {
            step.setRequestedInterface(ele.getAttribute("RequestedInterface"));
        }
        if (ele.getAttributeNode("JoinStepId") != null) {
            step.setJoinStepId(Integer.parseInt(ele.getAttribute("JoinStepId")));
        }
        if (ele.getAttributeNode("JoinType") != null) {
            step.setJoinType(VWJoinType.stringToType(ele.getAttribute("JoinType")));
        }
        if (ele.getAttributeNode("SplitType") != null) {
            step.setSplitType(VWSplitType.stringToType(ele.getAttribute("SplitType")));
        }
        if (ele.getAttributeNode("CanReassign") != null) {
            step.setCanReassign(VWXMLHandler.stringToBoolean(ele.getAttribute("CanReassign")));
        }
        if (ele.getAttributeNode("CanViewStatus") != null) {
            step.setCanViewStatus(VWXMLHandler.stringToBoolean(ele.getAttribute("CanViewStatus")));
        }
        if (ele.getAttributeNode("CanViewHistory") != null) {
            step.setCanViewHistory(VWXMLHandler.stringToBoolean(ele.getAttribute("CanViewHistory")));
        }
        if (ele.getAttributeNode("IgnoreInvalidUsers") != null) {
            step.setIgnoreInvalidUsers(VWXMLHandler.stringToBoolean(ele.getAttribute("IgnoreInvalidUsers")));
        }
        if (ele.getAttributeNode("Deadline") != null) {
            step.setDeadlineExpr(ele.getAttribute("Deadline"));
        }
        if (ele.getAttributeNode("DeadlineMap") != null) {
            step.setDeadlineMap(ele.getAttribute("DeadlineMap"));
        }
        if (ele.getAttributeNode("Reminder") != null) {
            step.setReminder(Long.parseLong(ele.getAttribute("Reminder")));
        }
        String xcoordStr = null;
        String ycoordStr = null;
        if (ele.getAttributeNode("XCoordinate") != null) {
            xcoordStr = ele.getAttribute("XCoordinate");
        }
        if (ele.getAttributeNode("YCoordinate") != null) {
            ycoordStr = ele.getAttribute("YCoordinate");
        }
        if (xcoordStr != null && ycoordStr != null) {
            step.setLocation(new Point(Integer.parseInt(xcoordStr), Integer.parseInt(ycoordStr)));
        }
        NodeList childNodes = aNode.getChildNodes();
        int numChilds = 0;
        if (childNodes != null) {
            numChilds = childNodes.getLength();
        }
        for (int i = 0; i < numChilds; ++i) {
            Node childNode = childNodes.item(i);
            String childNodeName = childNode.getNodeName();
            if (childNodeName.equals("Participant")) {
                step.setParticipants((VWParticipant[])partHandler.addElementToArray(step.getParticipants(), new VWParticipant(((Element)childNode).getAttribute("Val"))));
                continue;
            }
            if (childNodeName.equals("Response")) {
                step.setResponses((String[])responseHandler.addElementToArray(step.getResponses(), ((Element)childNode).getAttribute("Val")));
                continue;
            }
            if (childNodeName.equals("PreAssignments") || childNodeName.equals("PostAssignments")) {
                if (!childNode.hasChildNodes()) continue;
                NodeList assignNodes = childNode.getChildNodes();
                int childNodeCount = assignNodes.getLength();
                int AssignCount = 0;
                for (int k = 0; k < childNodeCount; ++k) {
                    if (assignNodes.item(k).getNodeType() != 1) continue;
                    ++AssignCount;
                }
                String[][] Assignments = new String[AssignCount][2];
                int assignIndex = 0;
                for (int j = 0; j < childNodeCount; ++j) {
                    Node asNode = assignNodes.item(j);
                    if (assignNodes.item(j).getNodeType() != 1 || assignNodes.item(j).getNodeName() != "Assign") continue;
                    Assignments[assignIndex][0] = ((Element)asNode).getAttribute("LVal");
                    Assignments[assignIndex][1] = ((Element)asNode).getAttribute("RVal");
                    ++assignIndex;
                }
                if (childNodeName.equals("PreAssignments")) {
                    step.setPreAssignments(Assignments);
                    continue;
                }
                step.setPostAssignments(Assignments);
                continue;
            }
            if (childNodeName.equals("ModelAttributes")) {
                Hashtable attributes = VWXML_30_parser.parseXMLModelAttributes(childNode);
                step.setAttributes(attributes);
                continue;
            }
            if (childNodeName.equals("Parameter")) {
                VWXML_30_parser.parseXMLParameterDefinition(childNode, step);
                continue;
            }
            if (childNodeName.equals("Route") && map != null) {
                VWXML_30_parser.parseXMLRouteDefinition(childNode, map);
                continue;
            }
            if (childNodeName.equals("StepOperation")) {
                Element opEle = (Element)childNode;
                step.setOperationName(opEle.getAttribute("Name"));
                if (!childNode.hasChildNodes()) continue;
                NodeList opChildNodes = childNode.getChildNodes();
                int childNodeCount = opChildNodes.getLength();
                int opParamCount = 0;
                for (int n = 0; n < childNodeCount; ++n) {
                    if (opChildNodes.item(n).getNodeType() != 1) continue;
                    ++opParamCount;
                }
                String[] opParams = new String[opParamCount];
                int paramIndex = 0;
                for (int k = 0; k < opChildNodes.getLength(); ++k) {
                    Node opParamChildNode = opChildNodes.item(k);
                    if (opParamChildNode.getNodeType() != 1) continue;
                    opParams[paramIndex] = ((Element)opParamChildNode).getAttribute("Val");
                    ++paramIndex;
                }
                step.setOperationParameters(opParams);
                continue;
            }
            if (childNode.getNodeName().equals("PreRule") && map != null) {
                VWXML_30_parser.parseXMLStepRulesList(childNode, step, 0);
                continue;
            }
            if (childNode.getNodeName().equals("UpdateRule") && map != null) {
                VWXML_30_parser.parseXMLStepRulesList(childNode, step, 1);
                continue;
            }
            if (!childNode.getNodeName().equals("PostRule") || map == null) continue;
            VWXML_30_parser.parseXMLStepRulesList(childNode, step, 2);
        }
    }

    protected static void parseXMLCompoundStepDefinition(Node aNode, VWMapDefinition map, VWStepPaletteDefinition spDef) throws VWException, SAXException {
        VWCompoundStepDefinition compStep = null;
        Element ele = (Element)aNode;
        if (map != null) {
            compStep = map.createEmptyCompoundStep();
        } else if (spDef != null) {
            compStep = spDef.createEmptyCompoundStep();
        }
        if (ele.getAttributeNode("Name") != null) {
            compStep.setName(ele.getAttribute("Name"));
        }
        if (ele.getAttributeNode("StepId") != null) {
            compStep.setStepId(Integer.parseInt(ele.getAttribute("StepId")));
        }
        if (ele.getAttributeNode("Description") != null) {
            compStep.setDescription(ele.getAttribute("Description"));
        }
        String xcoordStr = null;
        String ycoordStr = null;
        if (ele.getAttributeNode("XCoordinate") != null) {
            xcoordStr = ele.getAttribute("XCoordinate");
        }
        if (ele.getAttributeNode("YCoordinate") != null) {
            ycoordStr = ele.getAttribute("YCoordinate");
        }
        if (xcoordStr != null && ycoordStr != null) {
            compStep.setLocation(new Point(Integer.parseInt(xcoordStr), Integer.parseInt(ycoordStr)));
        }
        if (ele.getAttributeNode("JoinStepId") != null) {
            compStep.setJoinStepId(Integer.parseInt(ele.getAttribute("JoinStepId")));
        }
        if (ele.getAttributeNode("JoinType") != null) {
            compStep.setJoinType(VWJoinType.stringToType(ele.getAttribute("JoinType")));
        }
        if (ele.getAttributeNode("SplitType") != null) {
            compStep.setSplitType(VWSplitType.stringToType(ele.getAttribute("SplitType")));
        }
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Instruction")) {
                VWXML_30_parser.parseXMLSimpleInstructionDefinition(childNode, compStep);
                continue;
            }
            if (childNode.getNodeName().equals("RBInstruction")) {
                VWXML_30_parser.parseXMLRBInstructionDefinition(childNode, compStep);
                continue;
            }
            if (childNode.getNodeName().equals("WFEInstruction")) {
                VWXML_30_parser.parseXMLWFEInstructionDefinition(childNode, compStep);
                continue;
            }
            if (childNode.getNodeName().equals("Route") && map != null) {
                VWXML_30_parser.parseXMLRouteDefinition(childNode, map);
                continue;
            }
            if (childNode.getNodeName().equals("PreRule") && map != null) {
                VWXML_30_parser.parseXMLStepRulesList(childNode, compStep, 0);
                continue;
            }
            if (childNode.getNodeName().equals("PostRule") && map != null) {
                VWXML_30_parser.parseXMLStepRulesList(childNode, compStep, 2);
                continue;
            }
            if (!childNode.getNodeName().equals("ModelAttributes")) continue;
            Hashtable attributes = VWXML_30_parser.parseXMLModelAttributes(childNode);
            compStep.setAttributes(attributes);
        }
    }

    protected static void parseXMLSimpleInstructionDefinition(Node aNode, VWCompoundStepDefinition compStep) throws VWException, SAXException {
        VWArrayHandler paramHandler = new VWArrayHandler(1, 1);
        String[] params = null;
        Element ele = (Element)aNode;
        VWInstructionDefinition newIns = compStep.createEmptyInstruction();
        if (ele.getAttributeNode("Id") != null) {
            newIns.setInstructionId(Integer.parseInt(ele.getAttribute("Id")));
        }
        if (ele.getAttributeNode("Action") != null) {
            newIns.setAction(VWActionType.stringToType(ele.getAttribute("Action")));
        }
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("Expression")) continue;
            params = (String[])paramHandler.addElementToArray(params, ((Element)childNode).getAttribute("Val"));
        }
        if (params != null) {
            ((VWSimpleInstruction)newIns).setParams((String[])paramHandler.getElements(params));
        }
    }

    protected static void parseXMLRBInstructionDefinition(Node aNode, VWCompoundStepDefinition compStep) throws VWException, SAXException {
        VWArrayHandler paramHandler = new VWArrayHandler(1, 1);
        String[] params = null;
        String compCallStr = null;
        int instId = -1;
        String reDoExprStr = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Id") != null) {
            instId = Integer.parseInt(ele.getAttribute("Id"));
        }
        if (ele.getAttributeNode("CompCall") != null) {
            compCallStr = ele.getAttribute("CompCall");
        }
        if (ele.getAttributeNode("ReDo") != null) {
            reDoExprStr = ele.getAttribute("ReDo");
        }
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("Expression")) continue;
            params = (String[])paramHandler.addElementToArray(params, ((Element)childNode).getAttribute("Val"));
        }
        VWInstructionDefinition newIns = compStep.createRollbackCheckpointInstruction(reDoExprStr, compCallStr, params);
        newIns.setInstructionId(instId);
    }

    protected static void parseXMLWFEInstructionDefinition(Node aNode, VWCompoundStepDefinition compStep) throws VWException, SAXException {
        String timeOutExprStr = null;
        int instId = -1;
        String eventNumLocLValueStr = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Id") != null) {
            instId = Integer.parseInt(ele.getAttribute("Id"));
        }
        if (ele.getAttributeNode("TimeOut") != null) {
            timeOutExprStr = ele.getAttribute("TimeOut");
        }
        if (ele.getAttributeNode("EventNumLoc") != null) {
            eventNumLocLValueStr = ele.getAttribute("EventNumLoc");
        }
        VWInstructionDefinition newIns = compStep.createWFEInstruction(timeOutExprStr, eventNumLocLValueStr);
        newIns.setInstructionId(instId);
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("Event")) continue;
            VWXML_30_parser.parseXMLEventDefinition(childNode, (VWWFEInstruction)newIns);
        }
    }

    protected static void parseXMLEventDefinition(Node aNode, VWWFEInstruction theWFEInst) throws VWException, SAXException, NumberFormatException {
        String wcNameStr = null;
        String opStr = null;
        String valueStr = null;
        String callISStr = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("WCName") != null) {
            wcNameStr = ele.getAttribute("WCName");
        }
        if (ele.getAttributeNode("Operator") != null) {
            opStr = ele.getAttribute("Operator");
        }
        if (ele.getAttributeNode("Value") != null) {
            valueStr = ele.getAttribute("Value");
        }
        if (ele.getAttributeNode("CallIS") != null) {
            callISStr = ele.getAttribute("CallIS");
        }
        VWEventDefinition newEvent = theWFEInst.createEvent();
        newEvent.setWorkClassName(wcNameStr);
        newEvent.setComparisonOperator(opStr);
        newEvent.setValue(valueStr);
        newEvent.setCallISName(callISStr);
        NodeList childNodes = aNode.getChildNodes();
        if (childNodes.getLength() > 0) {
            Vector<String[]> assignsFromXML_vect = new Vector<String[]>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!childNode.getNodeName().equals("Assign")) continue;
                String[] tmpA = new String[2];
                ele = (Element)childNode;
                if (ele.getAttributeNode("LVal") != null) {
                    tmpA[0] = ele.getAttribute("LVal");
                }
                if (ele.getAttributeNode("RVal") != null) {
                    tmpA[1] = ele.getAttribute("RVal");
                }
                assignsFromXML_vect.addElement(tmpA);
            }
            String[][] tmpAssignArray = new String[assignsFromXML_vect.size()][2];
            assignsFromXML_vect.copyInto((Object[])tmpAssignArray);
            newEvent.setAssignments(tmpAssignArray);
        }
    }

    protected static void parseXMLRouteDefinition(Node aNode, VWMapDefinition map) throws VWException, SAXException, NumberFormatException {
        String name = null;
        String condition = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Name") != null) {
            name = ele.getAttribute("Name");
        }
        if (ele.getAttributeNode("Condition") != null) {
            condition = ele.getAttribute("Condition");
        }
        VWMapNode step = map.getStep(Integer.parseInt(ele.getAttribute("SourceStepId")));
        VWRouteDefinition aRoute = step.createRoute(Integer.parseInt(ele.getAttribute("DestinationStepId")), condition, name);
        aRoute.setRelease(VWXMLHandler.stringToBoolean(ele.getAttribute("Release")));
    }

    protected static void parseXMLParameterDefinition(Node aNode, VWStepDefinition step) throws VWException, SAXException, NumberFormatException {
        String name = null;
        String valueStr = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Name") != null) {
            name = ele.getAttribute("Name");
        }
        if (ele.getAttributeNode("ValueExpr") != null) {
            valueStr = ele.getAttribute("ValueExpr");
        }
        VWParameterDefinition param = step.createParameter(name, VWModeType.stringToType(ele.getAttribute("Mode")), valueStr, VWFieldType.stringToType(ele.getAttribute("Type")), VWXMLHandler.stringToBoolean(ele.getAttribute("IsArray")));
        if (ele.getAttributeNode("Description") != null) {
            param.setDescription(ele.getAttribute("Description"));
        }
    }

    protected static Hashtable parseXMLModelAttributes(Node aNode) throws VWException, SAXException, NumberFormatException {
        Hashtable<String, String> ModelAttributes = null;
        if (aNode.hasChildNodes()) {
            NodeList assignNodes = aNode.getChildNodes();
            int childNodeCount = assignNodes.getLength();
            ModelAttributes = new Hashtable<String, String>();
            String keyValue = null;
            String val = null;
            for (int j = 0; j < childNodeCount; ++j) {
                Node asNode = assignNodes.item(j);
                if (assignNodes.item(j).getNodeType() != 1 || assignNodes.item(j).getNodeName() != "Assign") continue;
                keyValue = ((Element)asNode).getAttribute("LVal");
                val = ((Element)asNode).getAttribute("RVal");
                ModelAttributes.put(keyValue, val);
            }
        }
        return ModelAttributes;
    }

    protected static void parseXMLRuntimeId(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String serviceName = null;
        String id = null;
        Date timeStamp = null;
        int region = -1;
        int wcId = -1;
        int wcRevision = -1;
        if (ele.getAttributeNode("ServiceName") != null) {
            serviceName = ele.getAttribute("ServiceName");
        }
        if (ele.getAttributeNode("IsolatedRegion") != null) {
            region = Integer.parseInt(ele.getAttribute("IsolatedRegion"));
        }
        if (ele.getAttributeNode("IRTimeStamp") != null) {
            try {
                SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
                timeStamp = dateFormatter.parse(ele.getAttribute("IRTimeStamp"));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (ele.getAttributeNode("WorkClassId") != null) {
            wcId = Integer.parseInt(ele.getAttribute("WorkClassId"));
        }
        if (ele.getAttributeNode("WCRevision") != null) {
            wcRevision = Integer.parseInt(ele.getAttribute("WCRevision"));
        }
        if (ele.getAttributeNode("Id") != null) {
            id = ele.getAttribute("Id");
        }
        wfdef.setRuntimeId(new VWWorkflowRuntimeId(serviceName, region, timeStamp, wcId, wcRevision, id));
    }

    protected static void parseXMLStepRulesList(Node aNode, VWMapNode aStep, int RuleSetSelector) throws VWException {
        NodeList childNodes = aNode.getChildNodes();
        if (childNodes.getLength() > 0) {
            Vector<String> ruleVector = new Vector<String>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!childNode.getNodeName().equals("Expression")) continue;
                Element ele = (Element)childNode;
                String rsName = null;
                if (ele.getAttributeNode("Val") != null) {
                    rsName = ele.getAttribute("Val");
                }
                int idx = -1;
                try {
                    if (rsName != null) {
                        idx = Integer.parseInt(rsName);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (idx != -1) {
                    try {
                        rsName = aStep.getMap().getWorkflow().getRuleSetNameFromIndex(idx);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ruleVector.add(rsName);
            }
            aStep.setRuleSets(RuleSetSelector, ruleVector.toArray(new String[0]));
        }
    }

    protected static VWStepPaletteDefinition parseXMLStepPalette(Element spele) throws VWException, SAXException {
        if (!spele.getTagName().equals("StepPaletteDefinition")) {
            return null;
        }
        VWStepPaletteDefinition spdef = new VWStepPaletteDefinition();
        if (spele.getAttributeNode("Name") != null) {
            spdef.setName(spele.getAttribute("Name"));
        }
        if (spele.getAttributeNode("Description") != null) {
            spdef.setDescription(spele.getAttribute("Description"));
        }
        NodeList childNodes = spele.getChildNodes();
        int numChilds = 0;
        if (childNodes != null) {
            numChilds = childNodes.getLength();
        }
        for (int i = 0; i < numChilds; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Step")) {
                VWXML_30_parser.parseXMLStepDefinition(childNode, null, spdef);
                continue;
            }
            if (!childNode.getNodeName().equals("CompoundStep")) continue;
            VWXML_30_parser.parseXMLCompoundStepDefinition(childNode, null, spdef);
        }
        if (spele.getAttributeNode("MaxStepId") != null) {
            int maxStepId = Integer.parseInt(spele.getAttribute("MaxStepId"));
            if (maxStepId >= spdef.findHighestStepId()) {
                spdef.getStepIdGenerator().setNextId(maxStepId + 1);
            } else {
                spdef.updateNextStepId();
            }
        } else {
            spdef.updateNextStepId();
        }
        return spdef;
    }
}

